
package w83a.xml.exception;

import java.io.Serializable;

import w83a.w83aUtilidadesComunes.W83aException;


/**
 * Excepcin lanzada cuando se produce un error XML reseable.
 * <br><br>Adems de la informacin contenida en todos los objetos Exception
 * (message, cause y stack trace), cada instancia de esta clase contiene
 * tambin un cdigo de error.
 */

public class W83AXmlException extends W83aException implements Serializable {

   /**
    * Construye un objeto de la clase.
    * 
    * @param errorCode
    *           Cdigo de error.
    */
   	
   public W83AXmlException(long errorCode) {
      super("w83a",errorCode);
   }

   /**
    * Construye un objeto de la clase.
    * 
    * @param errorCode
    *           Cdigo de error.
    * @param cause
    *           Excepcin que ha causado sta.
    */

   public W83AXmlException(long errorCode, Throwable cause) {
      super("w83a", errorCode, cause);
   }

}
